"use client"

import { useState, useEffect } from "react"
import { Card, CardContent } from "@/components/ui/card"
import { Button } from "@/components/ui/button"
import { Star, ChevronLeft, ChevronRight, MessageCircle } from "lucide-react"

const testimonials = [
  {
    id: 1,
    name: "Carlos Mendoza",
    location: "Bogotá",
    rating: 5,
    text: "¡Increíble servicio! Me respondieron por WhatsApp en menos de 1 minuto y la batería llegó el mismo día. Mi carro quedó como nuevo. 100% recomendado.",
    image: "/happy-customer-male-automotive.jpg",
  },
  {
    id: 2,
    name: "María Fernández",
    location: "Medellín",
    rating: 5,
    text: "Excelente atención por WhatsApp. Los asesores son súper profesionales y me ayudaron a elegir la batería perfecta para mi vehículo. Precios inmejorables.",
    image: "/happy-customer-female-automotive.jpg",
  },
  {
    id: 3,
    name: "Roberto Silva",
    location: "Cali",
    rating: 5,
    text: "La mejor experiencia comprando baterías. Todo por WhatsApp, súper fácil y rápido. La instalación fue perfecta y el precio increíble. ¡Volveré a comprar aquí!",
    image: "/satisfied-customer-male-mechanic.jpg",
  },
  {
    id: 4,
    name: "Ana Rodríguez",
    location: "Barranquilla",
    rating: 5,
    text: "Quedé fascinada con el servicio. Los asesores por WhatsApp son muy atentos y conocen mucho del tema. Mi batería funciona perfecta después de 6 meses.",
    image: "/happy-customer-female-professional.jpg",
  },
  {
    id: 5,
    name: "Diego Martínez",
    location: "Cartagena",
    rating: 5,
    text: "Servicio de primera. Contacté por WhatsApp un domingo y me atendieron inmediatamente. La batería llegó el lunes temprano. ¡Excelente empresa!",
    image: "/satisfied-customer-male-business.jpg",
  },
]

export function TestimonialsCarousel() {
  const [currentIndex, setCurrentIndex] = useState(0)

  useEffect(() => {
    const timer = setInterval(() => {
      setCurrentIndex((prev) => (prev + 1) % testimonials.length)
    }, 4000)

    return () => clearInterval(timer)
  }, [])

  const nextTestimonial = () => {
    setCurrentIndex((prev) => (prev + 1) % testimonials.length)
  }

  const prevTestimonial = () => {
    setCurrentIndex((prev) => (prev - 1 + testimonials.length) % testimonials.length)
  }

  const handleWhatsAppClick = () => {
    const message = encodeURIComponent(
      "¡Hola! He visto las excelentes reseñas de sus clientes y me interesa conocer más sobre sus baterías. ¿Pueden ayudarme con información y precios? 😊",
    )
    window.open(`https://wa.me/573001234567?text=${message}`, "_blank")
  }

  return (
    <section className="py-16 bg-muted">
      <div className="container mx-auto px-4">
        <div className="text-center mb-12">
          <h2 className="text-4xl font-bold mb-4 gradient-text">¡Nuestros Clientes Están Felices! 😊</h2>
          <p className="text-xl text-muted-foreground max-w-2xl mx-auto">
            Miles de clientes satisfechos nos recomiendan. Lee sus experiencias reales comprando por WhatsApp
          </p>
        </div>

        <div className="relative max-w-4xl mx-auto">
          <Card className="bg-white shadow-2xl overflow-hidden">
            <CardContent className="p-8">
              <div className="flex items-center gap-6">
                <img
                  src={testimonials[currentIndex].image || "/placeholder.svg"}
                  alt={testimonials[currentIndex].name}
                  className="w-16 h-16 rounded-full border-4 border-primary"
                />

                <div className="flex-1">
                  <div className="flex items-center gap-2 mb-2">
                    <h3 className="text-xl font-bold">{testimonials[currentIndex].name}</h3>
                    <span className="text-muted-foreground">• {testimonials[currentIndex].location}</span>
                  </div>

                  <div className="flex items-center gap-1 mb-4">
                    {[...Array(testimonials[currentIndex].rating)].map((_, i) => (
                      <Star key={i} className="w-5 h-5 fill-yellow-400 text-yellow-400" />
                    ))}
                  </div>

                  <p className="text-lg text-gray-700 italic">"{testimonials[currentIndex].text}"</p>
                </div>
              </div>
            </CardContent>
          </Card>

          {/* Controles de navegación */}
          <Button
            variant="outline"
            size="icon"
            className="absolute left-4 top-1/2 -translate-y-1/2 bg-white shadow-lg hover:bg-gray-50"
            onClick={prevTestimonial}
          >
            <ChevronLeft className="w-5 h-5" />
          </Button>

          <Button
            variant="outline"
            size="icon"
            className="absolute right-4 top-1/2 -translate-y-1/2 bg-white shadow-lg hover:bg-gray-50"
            onClick={nextTestimonial}
          >
            <ChevronRight className="w-5 h-5" />
          </Button>

          {/* Indicadores */}
          <div className="flex justify-center gap-2 mt-6">
            {testimonials.map((_, index) => (
              <button
                key={index}
                className={`w-3 h-3 rounded-full transition-all ${
                  index === currentIndex ? "bg-primary" : "bg-gray-300"
                }`}
                onClick={() => setCurrentIndex(index)}
              />
            ))}
          </div>
        </div>

        <div className="text-center mt-12">
          <div className="bg-gradient-to-r from-green-500 to-green-600 text-white rounded-2xl p-8 max-w-2xl mx-auto">
            <h3 className="text-2xl font-bold mb-4">¡Únete a Miles de Clientes Satisfechos!</h3>
            <p className="text-lg mb-6">Experimenta el mismo servicio excepcional que han recibido nuestros clientes</p>
            <Button
              onClick={handleWhatsAppClick}
              className="bg-white text-green-600 hover:bg-gray-100 font-bold px-8 py-3 pulse-glow"
            >
              <MessageCircle className="w-5 h-5 mr-2" />
              ¡Quiero el Mismo Servicio!
            </Button>
          </div>
        </div>
      </div>
    </section>
  )
}
