import { Search, ShoppingCart, MessageCircle } from "lucide-react"

const steps = [
  {
    icon: Search,
    title: "Busca",
    description: "Filtra por marca, modelo y año de tu vehículo para encontrar las baterías compatibles.",
  },
  {
    icon: ShoppingCart,
    title: "Selecciona",
    description: "Agrega las especificaciones, agrega el carrito y procede con tu compra.",
  },
  {
    icon: MessageCircle,
    title: "Pídela por WhatsApp",
    description: "Pregunta sobre tu disponibilidad para coordinar la entrega o instalación.",
  },
]

export function ProcessSteps() {
  return (
    <section className="py-16">
      <div className="container mx-auto px-4">
        <div className="text-center mb-12">
          <h2 className="text-3xl font-bold mb-4">Obtén tu batería ideal en 3 simples pasos</h2>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          {steps.map((step, index) => (
            <div key={index} className="text-center">
              <div className="relative mb-6">
                <div className="w-16 h-16 bg-secondary rounded-full flex items-center justify-center mx-auto mb-4">
                  <step.icon className="h-8 w-8 text-secondary-foreground" />
                </div>
                <div className="absolute -top-2 -right-2 w-8 h-8 bg-primary rounded-full flex items-center justify-center text-primary-foreground font-bold">
                  {index + 1}
                </div>
              </div>
              <h3 className="text-xl font-semibold mb-3">{step.title}</h3>
              <p className="text-muted-foreground text-pretty">{step.description}</p>
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}
