import { Button } from "@/components/ui/button"
import { Search, ShoppingCart, User } from "lucide-react"

export function Header() {
  return (
    <header className="bg-secondary text-secondary-foreground">
      <div className="container mx-auto px-4 py-3">
        <div className="flex items-center justify-between">
          <div className="flex items-center space-x-4">
            <div className="text-xl font-bold">BateríasPro</div>
            <nav className="hidden md:flex space-x-6">
              <a href="#" className="hover:text-accent-foreground transition-colors">
                Inicio
              </a>
              <a href="#" className="hover:text-accent-foreground transition-colors">
                Catálogo
              </a>
              <a href="#" className="hover:text-accent-foreground transition-colors">
                ¿Cómo comprar?
              </a>
              <a href="#" className="hover:text-accent-foreground transition-colors">
                Servicios
              </a>
            </nav>
          </div>
          <div className="flex items-center space-x-4">
            <Button variant="ghost" size="sm" className="text-secondary-foreground hover:text-accent-foreground">
              <Search className="h-4 w-4" />
            </Button>
            <Button variant="ghost" size="sm" className="text-secondary-foreground hover:text-accent-foreground">
              <ShoppingCart className="h-4 w-4" />
            </Button>
            <Button variant="ghost" size="sm" className="text-secondary-foreground hover:text-accent-foreground">
              <User className="h-4 w-4" />
            </Button>
          </div>
        </div>
      </div>
    </header>
  )
}
