import { Button } from "@/components/ui/button"
import { Card, CardContent, CardFooter, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"

const featuredProducts = [
  {
    id: 1,
    name: "Batería LTH L-47-750",
    image: "/car-battery-black-automotive-lth.jpg",
    price: "$ 2,799.00",
    originalPrice: "$ 3,200.00",
    specs: "CCA 750A/RC 120 MIN",
    isHighlighted: true,
  },
  {
    id: 2,
    name: "Batería LTH L-48-850",
    image: "/car-battery-black-automotive-lth.jpg",
    price: "$ 3,199.00",
    originalPrice: "$ 3,600.00",
    specs: "CCA 850A/RC 140 MIN",
    isHighlighted: true,
  },
  {
    id: 3,
    name: "Batería LTH L-49-950",
    image: "/car-battery-black-automotive-lth.jpg",
    price: "$ 3,599.00",
    originalPrice: "$ 4,000.00",
    specs: "CCA 950A/RC 160 MIN",
    isHighlighted: true,
  },
  {
    id: 4,
    name: "Batería LTH L-50-1000",
    image: "/car-battery-black-automotive-lth.jpg",
    price: "$ 3,999.00",
    originalPrice: "$ 4,500.00",
    specs: "CCA 1000A/RC 180 MIN",
    isHighlighted: true,
  },
]

export function FeaturedProducts() {
  return (
    <section className="py-16 bg-muted/30">
      <div className="container mx-auto px-4">
        <div className="text-center mb-12">
          <h2 className="text-3xl font-bold mb-4">Productos destacados</h2>
          <div className="flex justify-center space-x-4 mb-8">
            <Badge variant="default" className="bg-primary text-primary-foreground">
              Todo
            </Badge>
            <Badge variant="outline">Bosch</Badge>
            <Badge variant="outline">Acdelco</Badge>
            <Badge variant="outline">Gonher</Badge>
          </div>
          <p className="text-muted-foreground">Ver más productos</p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
          {featuredProducts.map((product) => (
            <Card key={product.id} className="group hover:shadow-lg transition-shadow">
              <CardHeader className="text-center">
                <img
                  src={product.image || "/placeholder.svg"}
                  alt={product.name}
                  className="w-full h-48 object-contain mb-4"
                />
                <CardTitle className="text-lg">{product.name}</CardTitle>
                <p className="text-sm text-muted-foreground">{product.specs}</p>
              </CardHeader>
              <CardContent className="text-center">
                <div className="space-y-2">
                  <p className="text-2xl font-bold text-primary">{product.price}</p>
                  {product.originalPrice && (
                    <p className="text-sm text-muted-foreground line-through">{product.originalPrice}</p>
                  )}
                </div>
              </CardContent>
              <CardFooter>
                <Button className="w-full bg-primary hover:bg-primary/90 text-primary-foreground">
                  Seleccionar opciones
                </Button>
              </CardFooter>
            </Card>
          ))}
        </div>
      </div>
    </section>
  )
}
