const brands = [
  { name: "LTH", logo: "/lth-battery-brand-logo.jpg" },
  { name: "Bosch", logo: "/bosch-automotive-brand-logo.jpg" },
  { name: "AC Delco", logo: "/ac-delco-automotive-brand-logo.jpg" },
  { name: "Gonher", logo: "/gonher-battery-brand-logo.jpg" },
  { name: "Optima", logo: "/optima-battery-brand-logo.jpg" },
  { name: "Interstate", logo: "/interstate-battery-brand-logo.jpg" },
]

export function BrandsSection() {
  return (
    <section className="py-16 bg-muted/30">
      <div className="container mx-auto px-4">
        <div className="text-center mb-12">
          <h2 className="text-3xl font-bold mb-4">Marcas de baterías</h2>
        </div>

        <div className="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-8">
          {brands.map((brand, index) => (
            <div
              key={index}
              className="flex items-center justify-center p-4 bg-white rounded-lg shadow-sm hover:shadow-md transition-shadow"
            >
              <img
                src={brand.logo || "/placeholder.svg"}
                alt={`${brand.name} logo`}
                className="max-h-12 w-auto grayscale hover:grayscale-0 transition-all"
              />
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}
